/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.Map;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.EventNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BoundaryEventHandler
extends AbstractNodeHandler {
    protected Node createNode(Attributes attrs) {
        return new EventNode();
    }

    public Class generateNodeFor() {
        return EventNode.class;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        String attachedTo = element.getAttribute("attachedToRef");
        String cancelActivityString = element.getAttribute("cancelActivity");
        boolean cancelActivity = true;
        if ("false".equals(cancelActivityString)) {
            cancelActivity = false;
        }
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("escalationEventDefinition".equals(nodeName)) {
                this.handleEscalationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                this.handleErrorNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                this.handleTimerNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("compensateEventDefinition".equals(nodeName)) {
                this.handleCompensationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if (!"signalEventDefinition".equals(nodeName)) continue;
            this.handleSignalNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode(node);
        return node;
    }

    protected void handleEscalationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", attachedTo);
        eventNode.setMetaData("CancelActivity", cancelActivity);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String escalationRef;
            String nodeName = xmlNode.getNodeName();
            if (!"escalationEventDefinition".equals(nodeName) || (escalationRef = ((Element)xmlNode).getAttribute("escalationRef")) == null || escalationRef.trim().length() <= 0) continue;
            Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("Escalations");
            if (escalations == null) {
                throw new IllegalArgumentException("No escalations found");
            }
            Escalation escalation = (Escalation)escalations.get(escalationRef);
            if (escalation == null) {
                throw new IllegalArgumentException("Could not find escalation " + escalationRef);
            }
            ArrayList<EventFilter> eventFilters = new ArrayList<EventFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            String type = escalation.getEscalationCode();
            eventFilter.setType("Escalation-" + attachedTo + "-" + type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("EscalationEvent", type);
        }
    }

    protected void handleErrorNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String errorRef;
            String nodeName = xmlNode.getNodeName();
            if (!"errorEventDefinition".equals(nodeName) || (errorRef = ((Element)xmlNode).getAttribute("errorRef")) == null || errorRef.trim().length() <= 0) continue;
            Map errors = (Map)((ProcessBuildData)parser.getData()).getMetaData("Errors");
            if (errors == null) {
                throw new IllegalArgumentException("No errors found");
            }
            Error error = (Error)errors.get(errorRef);
            if (error == null) {
                throw new IllegalArgumentException("Could not find error " + errorRef);
            }
            String type = error.getErrorCode();
            ArrayList<EventFilter> eventFilters = new ArrayList<EventFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Error-" + attachedTo + "-" + type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("ErrorEvent", type);
        }
    }

    protected void handleTimerNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", attachedTo);
        eventNode.setMetaData("CancelActivity", cancelActivity);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            EventTypeFilter eventFilter;
            ArrayList<EventFilter> eventFilters;
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            String timeDuration = null;
            String timeCycle = null;
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String subNodeName = subNode.getNodeName();
                if ("timeDuration".equals(subNodeName)) {
                    timeDuration = subNode.getTextContent();
                    break;
                }
                if ("timeCycle".equals(subNodeName)) {
                    timeCycle = subNode.getTextContent();
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            if (timeDuration != null && timeDuration.trim().length() > 0) {
                eventFilters = new ArrayList<EventFilter>();
                eventFilter = new EventTypeFilter();
                eventFilter.setType("Timer-" + attachedTo + "-" + timeDuration);
                eventFilters.add(eventFilter);
                eventNode.setEventFilters(eventFilters);
                eventNode.setMetaData("TimeDuration", timeDuration);
                continue;
            }
            if (timeCycle == null || timeCycle.trim().length() <= 0) continue;
            eventFilters = new ArrayList();
            eventFilter = new EventTypeFilter();
            eventFilter.setType("Timer-" + attachedTo + "-" + timeCycle);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("TimeCycle", timeCycle);
        }
    }

    protected void handleCompensationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        NodeList childs = element.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            String activityRef;
            Element el;
            if (!(childs.item(i) instanceof Element) || !"compensateEventDefinition".equalsIgnoreCase((el = (Element)childs.item(i)).getNodeName()) || (activityRef = el.getAttribute("activityRef")) == null || activityRef.length() <= 0) continue;
            eventNode.setMetaData("ActivityRef", activityRef);
        }
        eventNode.setMetaData("AttachedTo", attachedTo);
        ArrayList<EventFilter> eventFilters = new ArrayList<EventFilter>();
        EventTypeFilter eventFilter = new EventTypeFilter();
        String eventType = "Compensate-";
        eventFilter.setType(eventType);
        eventFilters.add(eventFilter);
        ((EventNode)node).setEventFilters(eventFilters);
    }

    protected void handleSignalNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", attachedTo);
        eventNode.setMetaData("CancelActivity", cancelActivity);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String type;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, eventNode);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName) || (type = ((Element)xmlNode).getAttribute("signalRef")) == null || type.trim().length() <= 0) continue;
            ArrayList<EventFilter> eventFilters = new ArrayList<EventFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType(type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setScope("external");
            eventNode.setMetaData("SignalName", type);
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, EventNode eventNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        subNode = subNode.getNextSibling();
        String to = subNode.getTextContent();
        eventNode.setVariableName(to);
    }

    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

